import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/attribute/attribute_controller.dart';

class EditAttributePopup extends StatefulWidget {
  final String attributeName;
  final String attributeId;
  const EditAttributePopup(
      {super.key, required this.attributeName, required this.attributeId});

  @override
  State<EditAttributePopup> createState() => _EditAttributePopupState();
}

class _EditAttributePopupState extends State<EditAttributePopup> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<AttributeController>(builder: (controller) {
      controller.attributeController.text = widget.attributeName;
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Row(
              children: [
                Expanded(
                    child: Text(MyStrings.updateAttribute.tr,
                        style: theme.textTheme.headlineSmall)),
                GestureDetector(
                  onTap: () {
                    Get.back();
                  },
                  child: MyAssetImageWidget(
                    assetPath: MyIcons.popUpCancel,
                    height: Dimensions.space45.h,
                    width: Dimensions.space45.w,
                    isSvg: true,
                  ),
                )
              ],
            ),
          ),
          CustomDivider(),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.attributeController,
              labelText: MyStrings.attribute.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Column(
              children: [
                spaceDown(Dimensions.space48.h),
                CustomElevatedBtn(
                  isLoading: controller.isSubmitting,
                  text: MyStrings.update.tr,
                  onTap: () {
                    controller.updateAttribute(widget.attributeId);
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ],
            ),
          ),
        ],
      );
    });
  }
}
