import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/attribute/widgets/edit_attribute_pop_up.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/attribute/attribute_controller.dart';
import 'package:ovosale/data/model/attribute/attribute_response_model.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class AttributeListTile extends StatelessWidget {
  final List<AttributeData> attributeDataList;
  final int index;
  const AttributeListTile({
    super.key,
    required this.attributeDataList,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<AttributeController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Text(
            attributeDataList[index].name.toString(),
            style: theme.textTheme.headlineSmall
                ?.copyWith(fontSize: Dimensions.space16.sp),
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomSwitch(
              isLoading: controller.attributeUpdateLoadingIndex ==
                  controller.filteredAttributeDataList[index].id,
              value: controller.filteredAttributeDataList[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredAttributeDataList[index].id.toString(),
                    index,
                    v);
              },
            ),
            spaceSide(Dimensions.space12),
            CustomAppCard(
                onPressed: () {
                  if (Get.find<GlobalController>().checkPermission(
                      featureName: AppPermissions.editAttribute)) {
                    CustomAlertDialog(
                        child: EditAttributePopup(
                      attributeName: attributeDataList[index].name.toString(),
                      attributeId: attributeDataList[index].id.toString(),
                    )).customAlertDialog(context);
                  }
                },
                showBorder: false,
                padding: EdgeInsetsDirectional.all(8),
                radius: Dimensions.space8,
                height: Dimensions.space32.h,
                width: Dimensions.space32.w,
                backgroundColor:
                    MyColor.getInformationColor().withValues(alpha: .2),
                child: MyAssetImageWidget(
                  assetPath: MyIcons.edit,
                  isSvg: true,
                  height: Dimensions.space10.h,
                  width: Dimensions.space16.w,
                )),
          ])),
    );
  }
}
