import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/attribute/new_attribute_controller.dart';
import 'package:ovosale/data/repo/attribute/new_attribute_repo.dart';

class NewAttrtibuteScreen extends StatefulWidget {
  const NewAttrtibuteScreen({super.key});

  @override
  State<NewAttrtibuteScreen> createState() => _NewAttrtibuteScreenState();
}

class _NewAttrtibuteScreenState extends State<NewAttrtibuteScreen> {
  @override
  void initState() {
    Get.put(NewAttributeRepo());

    Get.put(NewAttributeController(newAttributeRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewAttributeController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newAttribute.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    LabelTextField(
                      labelText: MyStrings.attributeName.tr,
                      hintText: MyStrings.hintCategory.tr,
                      controller: controller.attributeNameController,
                      isRequired: true,
                      onChanged: (value) {},
                      contentPadding: EdgeInsetsDirectional.symmetric(
                          vertical: Dimensions.space17.h,
                          horizontal: Dimensions.space16.w),
                      textInputType: TextInputType.text,
                      textInputAction: TextInputAction.done,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                    ),
                    spaceDown(Dimensions.space30.h),
                    CustomElevatedBtn(
                      isLoading: controller.submitLoading,
                      text: MyStrings.save.tr,
                      onTap: () {
                        if (controller.attributeNameController.text != "") {
                          controller.submitAttributeData();
                        } else {
                          CustomSnackBar.error(errorList: [
                            MyStrings.attributeNameisRequired.tr
                          ]);
                        }
                      },
                      height: Dimensions.space56.h,
                      radius: Dimensions.largeRadius,
                    ),
                  ])),
        ),
      ),
    );
  }
}
