import 'dart:async';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/no_data.dart';
import 'package:ovosale/app/components/shimmer/unit_shimmer.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/screens/attribute/widgets/attribute_tile.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/attribute/attribute_controller.dart';
import 'package:ovosale/data/repo/attribute/attribute_repo.dart';

import '../../../core/app_permission/app_permission.dart';
import '../../../data/controller/cart/global_controller.dart';

class AttributeScreen extends StatefulWidget {
  const AttributeScreen({super.key});

  @override
  State<AttributeScreen> createState() => _AttributeScreenState();
}

class _AttributeScreenState extends State<AttributeScreen> {
  Timer? _debounceTimer;
  @override
  void initState() {
    Get.put(AttributeRepo());
    final controller = Get.put(AttributeController(attributeRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getAttributes();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<AttributeController>(
      builder: (controller) => MyCustomScaffold(
        pageTitle: MyStrings.attribute.tr,
        padding: EdgeInsets.zero,
        body: Column(
          children: [
            Container(
              padding: EdgeInsetsDirectional.symmetric(
                  horizontal: Dimensions.space16.w,
                  vertical: Dimensions.space12.h),
              color: MyColor.white,
              child: LabelTextField(
                labelText: "",
                hideLabel: true,
                controller: controller.searchAttributeController,
                hintText: MyStrings.search.tr,
                hintTextColor: MyColor.getBodyTextColor(),
                onChanged: (value) {
                  if (_debounceTimer?.isActive ?? false) {
                    _debounceTimer?.cancel();
                  }

                  _debounceTimer = Timer(const Duration(milliseconds: 500), () {
                    controller.getAttributes();
                  });
                },
                textInputType: TextInputType.text,
                textInputAction: TextInputAction.done,
                radius: Dimensions.largeRadius,
                validator: (value) {
                  if (value!.isEmpty) {
                    return MyStrings.fieldErrorMsg.tr;
                  } else {
                    return null;
                  }
                },
                prefixIcon: Icon(
                  CupertinoIcons.search,
                  size: Dimensions.textFieldIconSize,
                ),
              ),
            ),
            spaceDown(Dimensions.space10),
            controller.isLoading
                ? UnitShimmer()
                : controller.filteredAttributeDataList.isEmpty &&
                        !controller.isLoading
                    ? Center(
                        child: SizedBox(
                          height: MediaQuery.of(context).size.height * 0.5,
                          child: NoDataWidget(),
                        ),
                      )
                    : Expanded(
                        child: CustomAppCard(
                            radius: 0,
                            showBorder: false,
                            child: ListView.separated(
                                physics: const BouncingScrollPhysics(),
                                separatorBuilder: (context, index) =>
                                    CustomDivider(space: Dimensions.space16.h),
                                shrinkWrap: true,
                                itemCount:
                                    controller.filteredAttributeDataList.length,
                                itemBuilder: (context, i) {
                                  return GestureDetector(
                                    onTap: () {},
                                    child: AttributeListTile(
                                      attributeDataList:
                                          controller.filteredAttributeDataList,
                                      index: i,
                                    ),
                                  );
                                })),
                      )
          ],
        ),
        floatingActionButton: CustomAppCard(
          onPressed: () {
            if (Get.find<GlobalController>()
                .checkPermission(featureName: AppPermissions.addAttribute)) {
              Get.toNamed(RouteHelper.newAttributeScreen)?.then((v) {
                controller.getAttributes();
              });
            }
          },
          height: Dimensions.space64.h,
          width: Dimensions.space64.w,
          padding: EdgeInsetsDirectional.all(Dimensions.space20),
          backgroundColor: MyColor.getPrimaryColor(),
          showBorder: false,
          child: MyAssetImageWidget(
            color: theme.cardColor,
            assetPath: MyIcons.add,
            isSvg: true,
          ),
        ),
      ),
    );
  }
}
