// ignore_for_file: void_checks

import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';

import '../../core/utils/my_strings.dart';
import 'dialog/warning_dialog.dart';

class WillPopWidget extends StatelessWidget {
  final Widget child;
  final String nextRoute;

  const WillPopWidget({super.key, required this.child, this.nextRoute = ''});

  @override
  Widget build(BuildContext context) {
    return PopScope(
        canPop: false,
        onPopInvokedWithResult: (c, d) async {
          if (nextRoute.toString().trim().isEmpty) {
            showWarningDialog(
                onTap: () {
                  SystemNavigator.pop();
                },
                context: context,
                desc: MyStrings.exitTitle.tr);
            return Future.value(false);
          } else {
            Get.offAndToNamed(nextRoute);
            return Future.value(false);
          }
        },
        child: child);
  }
}
