import 'package:flutter/material.dart';
import 'package:ovosale/app/components/text/label_text.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

class CustomDropDownTextField extends StatefulWidget {
  final dynamic selectedValue;
  final String? labelText;
  final String? hintText;
  final Function(dynamic)? onChanged;
  final List<DropdownMenuItem<dynamic>>? items;
  final Color? fillColor;
  final Color? focusColor;
  final Color? dropDownColor;
  final Color? iconColor;
  final double radius;
  final bool needLabel;
  final bool isRequired;
  final bool readOnly;

  const CustomDropDownTextField(
      {super.key,
      this.labelText,
      this.hintText,
      required this.selectedValue,
      required this.onChanged,
      required this.items,
      this.fillColor = MyColor.transparent,
      this.focusColor = MyColor.white,
      this.dropDownColor = MyColor.white,
      this.iconColor = MyColor.black,
      this.radius = 12,
      this.needLabel = true,
      this.isRequired = true,
      this.readOnly = false});

  @override
  State<CustomDropDownTextField> createState() =>
      _CustomDropDownTextFieldState();
}

class _CustomDropDownTextFieldState extends State<CustomDropDownTextField> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);

    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        widget.needLabel
            ? LabelText(
                text: widget.labelText.toString(),
                textStyle: theme.textTheme.labelMedium?.copyWith(
                    fontSize: Dimensions.space15.sp, color: MyColor.black),
                isRequired: widget.isRequired,
              )
            : const SizedBox(),
        widget.needLabel
            ? const SizedBox(height: Dimensions.textToTextSpace)
            : const SizedBox(),
        SizedBox(
          height: 56.h,
          child: IgnorePointer(
            ignoring: widget.readOnly,
            child: DropdownButtonFormField(
              initialValue: widget.selectedValue,
              dropdownColor: widget.dropDownColor,
              focusColor: widget.focusColor,
              style: theme.textTheme.bodySmall?.copyWith(
                  fontSize: Dimensions.space12.sp,
                  color: MyColor.getBodyTextColor().withValues(alpha: .5)),
              alignment: Alignment.centerLeft,
              decoration: InputDecoration(
                hintText: widget.hintText.toString(),
                filled: true,
                fillColor: widget.fillColor,
                hintStyle:
                    regularSmall.copyWith(color: MyColor.getBodyTextColor()),
                contentPadding: EdgeInsets.symmetric(
                    vertical: Dimensions.space17.h,
                    horizontal: Dimensions.space8.w),
                border: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(widget.radius),
                  borderSide:
                      BorderSide(color: MyColor.getBorderColor(), width: 1),
                ),
                enabledBorder: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(widget.radius),
                  borderSide:
                      BorderSide(color: MyColor.getBorderColor(), width: 1),
                ),
                focusedBorder: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(widget.radius),
                  borderSide:
                      BorderSide(color: MyColor.getPrimaryColor(), width: 1),
                ),
                errorBorder: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(widget.radius),
                  borderSide:
                      BorderSide(color: MyColor.getErrorColor(), width: 1),
                ),
                focusedErrorBorder: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(widget.radius),
                  borderSide:
                      BorderSide(color: MyColor.getBorderColor(), width: 1),
                ),
              ),
              isExpanded: false,
              onChanged: widget.onChanged,
              items: widget.items,
              icon: Icon(
                Icons.arrow_drop_down,
                size: Dimensions.space20.h,
              ),
            ),
          ),
        )
      ],
    );
  }
}
