import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/core/utils/my_color.dart';

class CustomStep {
  final String title;
  final Widget content;
  final bool isActive;

  CustomStep({
    required this.title,
    required this.content,
    this.isActive = false,
  });
}

class CustomStepperWidget extends StatelessWidget {
  final int currentStep;
  final List<CustomStep> steps;
  final Function(int) onStepChanged;
  final EdgeInsets? margin;
  final EdgeInsets? padding;
  final bool hasThreeSteps;

  const CustomStepperWidget({
    super.key,
    required this.currentStep,
    required this.steps,
    required this.onStepChanged,
    this.margin,
    this.padding,
    this.hasThreeSteps = false,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Container(
      margin: margin ?? EdgeInsets.zero,
      padding: padding ?? EdgeInsets.zero,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CustomAppCard(
            margin: const EdgeInsets.symmetric(vertical: 10),
            padding: const EdgeInsets.all(12),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                _buildStepCircle(0, theme),
                _buildStepDivider(0, theme),
                _buildStepCircle(1, theme),
                if (hasThreeSteps) ...[
                  _buildStepDivider(1, theme),
                  _buildStepCircle(2, theme),
                ],
              ],
            ),
          ),
          steps[currentStep].content,

          const SizedBox(height: 20), // Add spacing before stepper
        ],
      ),
    );
  }

  Widget _buildStepCircle(int step, ThemeData theme) {
    return CircleAvatar(
      radius: 16,
      backgroundColor:
          currentStep == step ? theme.primaryColor : theme.tabBarTheme.indicatorColor ?? Colors.grey,
      child: Text(
        '${step + 1}',
        style: theme.textTheme.headlineSmall?.copyWith(
          color: currentStep == step ? MyColor.white : theme.hintColor,
        ),
      ),
    );
  }

  Widget _buildStepDivider(int step, ThemeData theme) {
    return Expanded(
      child: CustomDivider(
        color: currentStep > step ? theme.primaryColor : theme.tabBarTheme.indicatorColor ?? Colors.grey,
      ),
    );
  }
}
