import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'my_shimmer_widget.dart';

class UnitShimmer extends StatelessWidget {
  const UnitShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Container(
        decoration: BoxDecoration(
          color: MyColor.getBackgroundColor(),
          borderRadius: BorderRadius.circular(Dimensions.space8),
        ),
        child: CustomAppCard(
            radius: 0,
            showBorder: false,
            child: ListView.separated(
                physics: BouncingScrollPhysics(),
                separatorBuilder: (context, index) =>
                    CustomDivider(space: Dimensions.space16.h),
                shrinkWrap: true,
                itemCount: 8,
                itemBuilder: (context, i) {
                  return CustomAppCard(
                    showBorder: false,
                    child: MyShimmerWidget(
                      child: ListTile(
                        tileColor: MyColor.white,
                        contentPadding: EdgeInsetsDirectional.zero,
                        title: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              color: MyColor.white,
                              height: 15,
                              width: 200,
                            ),
                            spaceDown(Dimensions.space5),
                            Container(
                              color: MyColor.white,
                              height: Dimensions.space15,
                              width: Dimensions.space200,
                            ),
                            spaceDown(Dimensions.space5),
                            Container(
                              color: MyColor.white,
                              height: 10,
                              width: Dimensions.space200,
                            ),
                          ],
                        ),
                        trailing: Row(
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Container(
                              decoration: BoxDecoration(
                                  color: MyColor.white,
                                  borderRadius:
                                      BorderRadiusDirectional.circular(
                                          Dimensions.space20)),
                              height: Dimensions.space25.h,
                              width: Dimensions.space40.w,
                            ),
                            spaceSide(Dimensions.space10),
                            Container(
                              decoration: BoxDecoration(
                                  color: MyColor.white,
                                  borderRadius:
                                      BorderRadiusDirectional.circular(
                                          Dimensions.space10)),
                              height: Dimensions.space40.h,
                              width: Dimensions.space40.w,
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                })),
      ),
    );
  }
}
