import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import 'my_shimmer_widget.dart';

class StockReportShimmer extends StatelessWidget {
  const StockReportShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        color: MyColor.getBackgroundColor(),
        borderRadius: BorderRadius.circular(Dimensions.space8),
      ),
      child: CustomAppCard(
          radius: 0,
          showBorder: false,
          child: ListView.separated(
              physics: BouncingScrollPhysics(),
              separatorBuilder: (context, index) =>
                  CustomDivider(space: Dimensions.space16.h),
              shrinkWrap: true,
              itemCount: 8,
              itemBuilder: (context, i) {
                return CustomAppCard(
                  child: MyShimmerWidget(
                    child: ListTile(
                      tileColor: MyColor.white,
                      contentPadding: EdgeInsetsDirectional.zero,
                      leading: Container(
                        decoration: BoxDecoration(
                          shape: BoxShape.circle,
                          color: MyColor.white,
                        ),
                        height: Dimensions.space50.h,
                        width: Dimensions.space50.w,
                      ),
                      title: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Container(
                            color: MyColor.white,
                            height: 10,
                            width: 100,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: 10,
                            width: 50,
                          ),
                        ],
                      ),
                      trailing: CustomAppCard(
                          showBorder: false,
                          padding: EdgeInsetsDirectional.all(Dimensions.space8),
                          radius: Dimensions.space8,
                          height: Dimensions.space45.h,
                          width: Dimensions.space50.w,
                          backgroundColor: MyColor.getInformationColor()
                              .withValues(alpha: .2),
                          child: Container(
                            decoration: BoxDecoration(
                              borderRadius:
                                  BorderRadius.circular(Dimensions.space8),
                              color: MyColor.white,
                            ),
                            height: Dimensions.space20.h,
                            width: Dimensions.space20.w,
                          )),
                    ),
                  ),
                );
              })),
    );
  }
}
