import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import 'my_shimmer_widget.dart';

class ReportShimmer extends StatelessWidget {
  const ReportShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        color: MyColor.getBackgroundColor(),
        borderRadius: BorderRadius.circular(Dimensions.space8),
      ),
      child: CustomAppCard(
          radius: 0,
          showBorder: false,
          child: ListView.separated(
              physics: BouncingScrollPhysics(),
              separatorBuilder: (context, index) =>
                  CustomDivider(space: Dimensions.space16.h),
              shrinkWrap: true,
              itemCount: 8,
              itemBuilder: (context, i) {
                return CustomAppCard(
                  child: MyShimmerWidget(
                      child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space100,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                          spaceDown(Dimensions.space15),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space70,
                          ),
                        ],
                      ),
                      spaceSide(Dimensions.space10),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space100,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                        ],
                      ),
                      spaceSide(Dimensions.space10),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.end,
                        children: [
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space70,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            color: MyColor.white,
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                        ],
                      ),
                    ],
                  )),
                );
              })),
    );
  }
}
