import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import 'my_shimmer_widget.dart';

class ProfileShimmer extends StatelessWidget {
  const ProfileShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        spaceDown(Dimensions.space15),
        Padding(
          padding: const EdgeInsetsDirectional.symmetric(
            horizontal: Dimensions.horizontalScreenPadding,
          ),
          child: Container(
            width: MediaQuery.of(context).size.width,
            padding: const EdgeInsets.symmetric(
                vertical: Dimensions.space15, horizontal: Dimensions.space15),
            decoration: BoxDecoration(
                color: MyColor.getCardBackgroundColor(),
                borderRadius: BorderRadius.circular(10)),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Center(
                  child: CustomAppCard(
                    showBorder: false,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        MyShimmerWidget(
                          child: Container(
                            height: 100,
                            width: 100,
                            decoration: BoxDecoration(
                                shape: BoxShape.circle,
                                color: MyColor.getCardBackgroundColor()),
                          ),
                        ),
                        spaceDown(Dimensions.space15),
                        MyShimmerWidget(
                          child: Container(
                            height: Dimensions.space20.h,
                            width: Dimensions.space100.w,
                            decoration: BoxDecoration(
                                color: MyColor.getCardBackgroundColor()),
                          ),
                        ),
                        spaceDown(Dimensions.space5),
                        MyShimmerWidget(
                          child: Container(
                            height: Dimensions.space20.h,
                            width: Dimensions.space100.w,
                            decoration: BoxDecoration(
                                color: MyColor.getCardBackgroundColor()),
                          ),
                        ),
                        spaceDown(Dimensions.space5),
                        MyShimmerWidget(
                          child: Container(
                            height: Dimensions.space20.h,
                            width: Dimensions.space100.w,
                            decoration: BoxDecoration(
                                color: MyColor.getCardBackgroundColor()),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
                SizedBox(height: Dimensions.space45.h),
                Row(
                  children: [
                    MyShimmerWidget(
                      child: Container(
                        height: Dimensions.space30.h,
                        width: Dimensions.space30.w,
                        decoration: BoxDecoration(
                            shape: BoxShape.circle,
                            color: MyColor.getCardBackgroundColor()),
                      ),
                    ),
                    const SizedBox(width: Dimensions.space15),
                    Expanded(
                      child: MyShimmerWidget(
                        child: Container(
                          height: Dimensions.space30.h,
                          decoration: BoxDecoration(
                              color: MyColor.getCardBackgroundColor()),
                        ),
                      ),
                    ),
                    Spacer(),
                    MyShimmerWidget(
                      child: Container(
                        height: Dimensions.space30.h,
                        width: Dimensions.space30.w,
                        decoration: BoxDecoration(
                            color: MyColor.getCardBackgroundColor()),
                      ),
                    ),
                  ],
                ),
                const CustomDivider(space: Dimensions.space15),
                Row(
                  children: [
                    MyShimmerWidget(
                      child: Container(
                        height: Dimensions.space30.h,
                        width: Dimensions.space30.w,
                        decoration: BoxDecoration(
                            shape: BoxShape.circle,
                            color: MyColor.getCardBackgroundColor()),
                      ),
                    ),
                    const SizedBox(width: Dimensions.space15),
                    Expanded(
                      child: MyShimmerWidget(
                        child: Container(
                          height: Dimensions.space30.h,
                          decoration: BoxDecoration(
                              color: MyColor.getCardBackgroundColor()),
                        ),
                      ),
                    ),
                    Spacer(),
                    MyShimmerWidget(
                      child: Container(
                        height: Dimensions.space30.h,
                        width: Dimensions.space30.w,
                        decoration: BoxDecoration(
                            color: MyColor.getCardBackgroundColor()),
                      ),
                    ),
                  ],
                ),
                spaceDown(Dimensions.space10)
              ],
            ),
          ),
        ),
      ],
    );
  }
}
