import 'package:flutter/material.dart';
import 'package:ovosale/app/components/shimmer/my_shimmer_widget.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

class ProductDetailsShimmer extends StatelessWidget {
  const ProductDetailsShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return Container(
      width: double.infinity,
      padding: EdgeInsetsDirectional.symmetric(
          horizontal: Dimensions.horizontalScreenPadding,
          vertical: Dimensions.verticalScreenPadding),
      decoration: BoxDecoration(
        color: MyColor.getBackgroundColor(),
        borderRadius: BorderRadius.circular(Dimensions.space8),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          spaceDown(Dimensions.space20.h),
          MyShimmerWidget(
            child: Container(
              margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
              decoration: BoxDecoration(
                  color: MyColor.white,
                  borderRadius:
                      BorderRadiusDirectional.circular(Dimensions.space10)),
              height: size.width / 1.6,
              width: size.width / 1.2,
            ),
          ),
          spaceDown(Dimensions.space10.h),
          Center(
            child: MyShimmerWidget(
              child: Container(
                margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
                decoration: BoxDecoration(
                    color: MyColor.white,
                    borderRadius:
                        BorderRadiusDirectional.circular(Dimensions.space10)),
                height: 20,
                width: 200,
              ),
            ),
          ),
          spaceDown(Dimensions.space40.h),
          Row(
            children: [
              Column(
                children: [
                  MyShimmerWidget(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 100,
                        ),
                        spaceDown(Dimensions.space10),
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 100,
                        ),
                      ],
                    ),
                  ),
                  spaceDown(Dimensions.space30),
                  MyShimmerWidget(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 70,
                        ),
                        spaceDown(Dimensions.space10),
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 100,
                        ),
                      ],
                    ),
                  ),
                  spaceDown(Dimensions.space30),
                  MyShimmerWidget(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 70,
                        ),
                        spaceDown(Dimensions.space10),
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 100,
                        ),
                      ],
                    ),
                  ),
                ],
              ),
              spaceSide(Dimensions.space50),
              Column(
                children: [
                  MyShimmerWidget(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 70,
                        ),
                        spaceDown(Dimensions.space10),
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 100,
                        ),
                      ],
                    ),
                  ),
                  spaceDown(Dimensions.space30),
                  MyShimmerWidget(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 70,
                        ),
                        spaceDown(Dimensions.space10),
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 100,
                        ),
                      ],
                    ),
                  ),
                  spaceDown(Dimensions.space30),
                  MyShimmerWidget(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 70,
                        ),
                        spaceDown(Dimensions.space10),
                        Container(
                          margin:
                              EdgeInsetsDirectional.symmetric(horizontal: 5),
                          decoration: BoxDecoration(
                              color: MyColor.white,
                              borderRadius: BorderRadiusDirectional.circular(
                                  Dimensions.space10)),
                          height: 10,
                          width: 100,
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ],
          ),
          spaceDown(Dimensions.space40.h),
          MyShimmerWidget(
            child: Container(
              margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
              decoration: BoxDecoration(
                  color: MyColor.white,
                  borderRadius:
                      BorderRadiusDirectional.circular(Dimensions.space10)),
              height: 100,
              width: size.width / 1.1,
            ),
          ),
        ],
      ),
    );
  }
}
