import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'my_shimmer_widget.dart';

class PaymentShimmer extends StatelessWidget {
  const PaymentShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        color: MyColor.getBackgroundColor(),
        borderRadius: BorderRadius.circular(Dimensions.space8),
      ),
      child: CustomAppCard(
          radius: 0,
          showBorder: false,
          child: ListView.separated(
              physics: BouncingScrollPhysics(),
              separatorBuilder: (context, index) =>
                  CustomDivider(space: Dimensions.space16.h),
              shrinkWrap: true,
              itemCount: 3,
              itemBuilder: (context, i) {
                return CustomAppCard(
                  child: MyShimmerWidget(
                    child: ListTile(
                      tileColor: MyColor.white,
                      contentPadding: EdgeInsetsDirectional.zero,
                      leading: CustomAppCard(
                        height: Dimensions.space56.h,
                        width: Dimensions.space56.w,
                        radius: Dimensions.space8,
                        padding: EdgeInsetsDirectional.all(Dimensions.space4),
                        child: SizedBox(
                          height: 10,
                          width: 50,
                        ),
                      ),
                      title: Container(
                        color: MyColor.white,
                        height: 20,
                        width: 50,
                      ),
                    ),
                  ),
                );
              })),
    );
  }
}
