import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import 'my_shimmer_widget.dart';

class NewSaleShimmer extends StatelessWidget {
  const NewSaleShimmer({super.key, this.hideTopShimmer = false});

  final bool hideTopShimmer;
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        if (hideTopShimmer == false) ...[
          spaceDown(Dimensions.space15),
          Padding(
            padding: const EdgeInsetsDirectional.symmetric(
              horizontal: Dimensions.horizontalScreenPadding,
            ),
            child: MyShimmerWidget(
              child: Container(
                margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
                decoration: BoxDecoration(
                    color: MyColor.white,
                    borderRadius:
                        BorderRadiusDirectional.circular(Dimensions.space10)),
                height: Dimensions.space10,
                width: Dimensions.space70,
              ),
            ),
          ),
          spaceDown(Dimensions.space5),
          CustomAppCard(
              radius: 0,
              child: GridView.builder(
                  gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                      childAspectRatio: .9,
                      crossAxisSpacing: 5,
                      crossAxisCount: 6),
                  physics: BouncingScrollPhysics(),
                  shrinkWrap: true,
                  itemCount: 6,
                  itemBuilder: (context, i) {
                    return MyShimmerWidget(
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.spaceAround,
                        children: [
                          Expanded(
                            child: Container(
                              margin: EdgeInsetsDirectional.symmetric(
                                  horizontal: 5),
                              decoration: BoxDecoration(
                                  color: MyColor.white,
                                  borderRadius:
                                      BorderRadiusDirectional.circular(
                                          Dimensions.space10)),
                              height: Dimensions.space50,
                              width: Dimensions.space70,
                            ),
                          ),
                          spaceDown(Dimensions.space5),
                          Container(
                            margin:
                                EdgeInsetsDirectional.symmetric(horizontal: 5),
                            decoration: BoxDecoration(
                                color: MyColor.white,
                                borderRadius: BorderRadiusDirectional.circular(
                                    Dimensions.space10)),
                            height: Dimensions.space10,
                            width: Dimensions.space50,
                          ),
                        ],
                      ),
                    );
                  })),
          spaceDown(Dimensions.space15),
          Padding(
            padding: const EdgeInsetsDirectional.symmetric(
              horizontal: Dimensions.horizontalScreenPadding,
            ),
            child: MyShimmerWidget(
              child: Container(
                margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
                decoration: BoxDecoration(
                    color: MyColor.white,
                    borderRadius:
                        BorderRadiusDirectional.circular(Dimensions.space10)),
                height: Dimensions.space10,
                width: Dimensions.space70,
              ),
            ),
          ),
          spaceDown(Dimensions.space15),
        ],
        GridView.builder(
            gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                childAspectRatio: .7, crossAxisSpacing: 5, crossAxisCount: 4),
            physics: BouncingScrollPhysics(),
            shrinkWrap: true,
            itemCount: 8,
            itemBuilder: (context, i) {
              return MyShimmerWidget(
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: [
                    Expanded(
                      child: Container(
                        margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
                        decoration: BoxDecoration(
                            color: MyColor.white,
                            borderRadius: BorderRadiusDirectional.circular(
                                Dimensions.space10)),
                        height: Dimensions.space80,
                        width: Dimensions.space80,
                      ),
                    ),
                    spaceDown(Dimensions.space5),
                    Container(
                      margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
                      decoration: BoxDecoration(
                          color: MyColor.white,
                          borderRadius: BorderRadiusDirectional.circular(
                              Dimensions.space10)),
                      height: Dimensions.space10,
                      width: Dimensions.space50,
                    ),
                    spaceDown(Dimensions.space5),
                    Container(
                      margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
                      decoration: BoxDecoration(
                          color: MyColor.white,
                          borderRadius: BorderRadiusDirectional.circular(
                              Dimensions.space10)),
                      height: Dimensions.space10,
                      width: Dimensions.space50,
                    ),
                    spaceDown(Dimensions.space5),
                    Container(
                      margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
                      decoration: BoxDecoration(
                          color: MyColor.white,
                          borderRadius: BorderRadiusDirectional.circular(
                              Dimensions.space10)),
                      height: Dimensions.space10,
                      width: Dimensions.space50,
                    ),
                    spaceDown(Dimensions.space5),
                    Container(
                      margin: EdgeInsetsDirectional.symmetric(horizontal: 5),
                      decoration: BoxDecoration(
                          color: MyColor.white,
                          borderRadius: BorderRadiusDirectional.circular(
                              Dimensions.space10)),
                      height: Dimensions.space10,
                      width: Dimensions.space50,
                    ),
                    spaceDown(Dimensions.space5),
                  ],
                ),
              );
            })
      ],
    );
  }
}
