import 'package:flutter/material.dart';
import 'package:ovosale/app/components/shimmer/my_shimmer_widget.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

class NewPurchaseShimmer extends StatelessWidget {
  const NewPurchaseShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return Container(
      width: double.infinity,
      padding: EdgeInsetsDirectional.symmetric(
          horizontal: Dimensions.horizontalScreenPadding,
          vertical: Dimensions.verticalScreenPadding),
      decoration: BoxDecoration(
        color: MyColor.getBackgroundColor(),
        borderRadius: BorderRadius.circular(Dimensions.space8),
      ),
      child: Column(
        children: [
          spaceDown(Dimensions.space20.h),
          Expanded(
            child: ListView.separated(
                separatorBuilder: (context, index) => SizedBox(
                      height: Dimensions.space10,
                    ),
                shrinkWrap: true,
                itemCount: 10,
                itemBuilder: (BuildContext c, int i) => MyShimmerWidget(
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Container(
                                color: MyColor.white,
                                height: Dimensions.space20,
                                width: 150,
                              ),
                              spaceDown(Dimensions.space10),
                              Container(
                                decoration: BoxDecoration(
                                    color: MyColor.white,
                                    borderRadius:
                                        BorderRadiusDirectional.circular(
                                            Dimensions.space10)),
                                height: Dimensions.space50,
                                width: size.width / 1.1,
                              ),
                            ],
                          ),
                        ],
                      ),
                    )),
          )
        ],
      ),
    );
  }
}
