import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/shimmer/my_shimmer_widget.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

class DashboardShimmer extends StatelessWidget {
  const DashboardShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return Container(
      width: double.infinity,
      padding: EdgeInsetsDirectional.symmetric(
          horizontal: Dimensions.horizontalScreenPadding,
          vertical: Dimensions.verticalScreenPadding),
      decoration: BoxDecoration(
        color: MyColor.getBackgroundColor(),
        borderRadius: BorderRadius.circular(Dimensions.space8),
      ),
      child: Column(
        children: [
          spaceDown(Dimensions.space20.h),
          MyShimmerWidget(
            child: Row(
              children: [
                Container(
                  decoration: BoxDecoration(
                    shape: BoxShape.circle,
                    color: MyColor.white,
                  ),
                  height: Dimensions.space60,
                  width: Dimensions.space60,
                ),
                spaceSide(Dimensions.space10),
                Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                  Container(
                    color: MyColor.white,
                    height: Dimensions.space15,
                    width: Dimensions.space100,
                  ),
                  spaceDown(Dimensions.space5),
                  Container(
                    color: MyColor.white,
                    height: Dimensions.space10,
                    width: Dimensions.space150,
                  ),
                ]),
                Spacer(),
                Container(
                  decoration: BoxDecoration(
                      color: MyColor.white,
                      borderRadius:
                          BorderRadiusDirectional.circular(Dimensions.space10)),
                  height: Dimensions.space50,
                  width: Dimensions.space50,
                ),
              ],
            ),
          ),
          spaceDown(Dimensions.space20.h),
          CustomAppCard(
            width: double.infinity,
            backgroundColor: MyColor.white,
            height: Dimensions.space120.h,
            child: MyShimmerWidget(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        color: MyColor.white,
                        height: Dimensions.space20,
                        width: Dimensions.space150,
                      ),
                      spaceDown(Dimensions.space5),
                      Container(
                        color: MyColor.white,
                        height: Dimensions.space10,
                        width: Dimensions.space120,
                      ),
                    ],
                  ),
                  Align(
                    alignment: Alignment.topRight,
                    child: Container(
                      color: MyColor.white,
                      height: Dimensions.space40,
                      width: Dimensions.space100,
                    ),
                  ),
                ],
              ),
            ),
          ),
          spaceDown(Dimensions.space20),
          MyShimmerWidget(
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Container(
                  decoration: BoxDecoration(
                      color: MyColor.white,
                      borderRadius:
                          BorderRadiusDirectional.circular(Dimensions.space10)),
                  height: Dimensions.space60,
                  width: size.width / 2.5,
                ),
                Container(
                  decoration: BoxDecoration(
                      color: MyColor.white,
                      borderRadius:
                          BorderRadiusDirectional.circular(Dimensions.space10)),
                  height: Dimensions.space60,
                  width: size.width / 2.5,
                ),
              ],
            ),
          ),
          spaceDown(Dimensions.space20),
          MyShimmerWidget(
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                  Container(
                    color: MyColor.white,
                    height: Dimensions.space15,
                    width: Dimensions.space100,
                  ),
                  spaceDown(Dimensions.space10),
                  Container(
                    color: MyColor.white,
                    height: Dimensions.space20,
                    width: Dimensions.space150,
                  ),
                ]),
                Column(crossAxisAlignment: CrossAxisAlignment.end, children: [
                  Container(
                    color: MyColor.white,
                    height: Dimensions.space15,
                    width: Dimensions.space100,
                  ),
                  spaceDown(Dimensions.space10),
                  Container(
                    color: MyColor.white,
                    height: Dimensions.space20,
                    width: Dimensions.space150,
                  ),
                ]),
              ],
            ),
          ),
          spaceDown(Dimensions.space10),
          MyShimmerWidget(
            child: Stack(
              children: [
                Column(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Container(
                      color: MyColor.white,
                      height: Dimensions.space5,
                      width: size.width / 1.2,
                    ),
                    spaceDown(Dimensions.space150),
                    Container(
                      color: MyColor.white,
                      height: Dimensions.space5,
                      width: size.width / 1.2,
                    ),
                  ],
                ),
                Positioned(
                  top: Dimensions.space20,
                  left: Dimensions.space50,
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.end,
                    children: [
                      Container(
                        color: MyColor.white,
                        height: Dimensions.space100,
                        width: Dimensions.space15,
                      ),
                      spaceSide(Dimensions.space30),
                      Container(
                        color: MyColor.white,
                        height: Dimensions.space200,
                        width: Dimensions.space15,
                      ),
                      spaceSide(Dimensions.space30),
                      Container(
                        color: MyColor.white,
                        height: Dimensions.space150,
                        width: Dimensions.space15,
                      ),
                      spaceSide(Dimensions.space30),
                      Container(
                        color: MyColor.white,
                        height: Dimensions.space100,
                        width: Dimensions.space15,
                      ),
                      spaceSide(Dimensions.space30),
                      Container(
                        color: MyColor.white,
                        height: Dimensions.space150,
                        width: Dimensions.space15,
                      ),
                      spaceSide(Dimensions.space30),
                      Container(
                        color: MyColor.white,
                        height: Dimensions.space200,
                        width: Dimensions.space15,
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
          spaceDown(Dimensions.space50),
          MyShimmerWidget(
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Container(
                  color: MyColor.white,
                  height: Dimensions.space20,
                  width: 150,
                ),
                Container(
                  color: MyColor.white,
                  height: Dimensions.space30,
                  width: 100,
                ),
              ],
            ),
          ),
          spaceDown(Dimensions.space10),
          Expanded(
            child: ListView.separated(
                separatorBuilder: (context, index) => SizedBox(
                      height: Dimensions.space10,
                    ),
                shrinkWrap: true,
                itemCount: 10,
                itemBuilder: (BuildContext c, int i) => MyShimmerWidget(
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Container(
                                color: MyColor.white,
                                height: Dimensions.space20,
                                width: 150,
                              ),
                              spaceDown(Dimensions.space10),
                              Container(
                                color: MyColor.white,
                                height: Dimensions.space12,
                                width: 120,
                              ),
                            ],
                          ),
                          Container(
                            decoration: BoxDecoration(
                                color: MyColor.white,
                                borderRadius: BorderRadiusDirectional.circular(
                                    Dimensions.space10)),
                            height: Dimensions.space50,
                            width: 120,
                          ),
                        ],
                      ),
                    )),
          )
        ],
      ),
    );
  }
}
