import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import 'my_shimmer_widget.dart';

class CustomerDatabaseShimmer extends StatelessWidget {
  const CustomerDatabaseShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Container(
        decoration: BoxDecoration(
          color: MyColor.getBackgroundColor(),
          borderRadius: BorderRadius.circular(Dimensions.space8),
        ),
        child: CustomAppCard(
            radius: 0,
            showBorder: false,
            child: ListView.separated(
                physics: BouncingScrollPhysics(),
                separatorBuilder: (context, index) =>
                    CustomDivider(space: Dimensions.space16.h),
                shrinkWrap: true,
                itemCount: 8,
                itemBuilder: (context, i) {
                  return MyShimmerWidget(
                    child: ListTile(
                        tileColor: MyColor.white,
                        contentPadding: EdgeInsetsDirectional.zero,
                        title: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              color: MyColor.white,
                              height: Dimensions.space20.h,
                              width: Dimensions.space100,
                            ),
                            spaceDown(Dimensions.space5),
                            Container(
                              color: MyColor.white,
                              height: Dimensions.space10,
                              width: Dimensions.space150,
                            ),
                            spaceDown(Dimensions.space5),
                            Container(
                              color: MyColor.white,
                              height: Dimensions.space10,
                              width: Dimensions.space150,
                            ),
                            Row(
                              children: [
                                Container(
                                  color: MyColor.white,
                                  height: Dimensions.space10,
                                  width: Dimensions.space150,
                                ),
                              ],
                            )
                          ],
                        ),
                        trailing:
                            Row(mainAxisSize: MainAxisSize.min, children: [
                          CustomAppCard(
                              showBorder: false,
                              padding: EdgeInsetsDirectional.all(8),
                              radius: Dimensions.space8,
                              height: Dimensions.space40.h,
                              width: Dimensions.space40.w,
                              backgroundColor: MyColor.getInformationColor()
                                  .withValues(alpha: .2),
                              child: Container(
                                color: MyColor.white,
                                height: Dimensions.space40.h,
                                width: Dimensions.space40.w,
                              )),
                          spaceSide(Dimensions.space8),
                          CustomAppCard(
                              showBorder: false,
                              padding: EdgeInsetsDirectional.all(8),
                              radius: Dimensions.space8,
                              height: Dimensions.space35.h,
                              width: Dimensions.space60.w,
                              backgroundColor: MyColor.getInformationColor()
                                  .withValues(alpha: .2),
                              child: Container(
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(20),
                                  color: MyColor.white,
                                ),
                                height: Dimensions.space20.h,
                                width: Dimensions.space20.w,
                              )),
                        ])),
                  );
                })),
      ),
    );
  }
}
