import 'package:flutter/material.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import 'my_shimmer_widget.dart';

class BrandsShimmer extends StatelessWidget {
  const BrandsShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Container(
        decoration: BoxDecoration(
          color: MyColor.getBackgroundColor(),
          borderRadius: BorderRadius.circular(Dimensions.space8),
        ),
        child: CustomAppCard(
            radius: 0,
            showBorder: false,
            child: ListView.separated(
                physics: BouncingScrollPhysics(),
                separatorBuilder: (context, index) =>
                    CustomDivider(space: Dimensions.space16.h),
                shrinkWrap: true,
                itemCount: 8,
                itemBuilder: (context, i) {
                  return MyShimmerWidget(
                    child: ListTile(
                        tileColor: MyColor.white,
                        contentPadding: EdgeInsetsDirectional.zero,
                        leading: CustomAppCard(
                          height: Dimensions.space56.h,
                          width: Dimensions.space56.w,
                          radius: Dimensions.space8,
                          padding: EdgeInsetsDirectional.all(Dimensions.space4),
                          child: SizedBox(
                            height: 10,
                            width: 50,
                          ),
                        ),
                        title: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              color: MyColor.white,
                              height: 10,
                              width: 100,
                            ),
                            spaceDown(Dimensions.space5),
                            Container(
                              color: MyColor.white,
                              height: 10,
                              width: 50,
                            ),
                            spaceDown(Dimensions.space5),
                            Container(
                              color: MyColor.white,
                              height: 10,
                              width: 50,
                            ),
                            Row(
                              children: [
                                Container(
                                  color: MyColor.white,
                                  height: 10,
                                  width: 50,
                                ),
                                spaceSide(Dimensions.space5),
                                Container(
                                  color: MyColor.white,
                                  height: 10,
                                  width: 50,
                                ),
                              ],
                            )
                          ],
                        ),
                        trailing:
                            Row(mainAxisSize: MainAxisSize.min, children: [
                          CustomAppCard(
                              showBorder: false,
                              padding: EdgeInsetsDirectional.all(8),
                              radius: Dimensions.space8,
                              height: Dimensions.space40.h,
                              width: Dimensions.space40.w,
                              backgroundColor: MyColor.getInformationColor()
                                  .withValues(alpha: .2),
                              child: Container(
                                color: MyColor.white,
                                height: Dimensions.space40.h,
                                width: Dimensions.space40.w,
                              )),
                          spaceSide(Dimensions.space8),
                          CustomAppCard(
                              showBorder: false,
                              padding: EdgeInsetsDirectional.all(8),
                              radius: Dimensions.space8,
                              height: Dimensions.space35.h,
                              width: Dimensions.space60.w,
                              backgroundColor: MyColor.getInformationColor()
                                  .withValues(alpha: .2),
                              child: Container(
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(20),
                                  color: MyColor.white,
                                ),
                                height: Dimensions.space20.h,
                                width: Dimensions.space20.w,
                              )),
                        ])),
                  );
                })),
      ),
    );
  }
}
