import 'package:flutter/material.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import 'image/custom_svg_picture.dart';

class TextField2 extends StatefulWidget {
  final String hintText;
  final TextEditingController? controller;
  final FocusNode? focusNode;
  final FocusNode? nextFocus;
  final TextInputType keyboardType;
  final Color? fillColor;
  final Color? iconColor;
  final Color? focusBorderColor;
  final InputBorderType borderType;
  final int? maxLength;
  final TextInputAction? textInputAction;
  final TextStyle? textStyle;
  final TextStyle? hintStyle;
  final VoidCallback? onTap;
  final Function(String)? onChanged;
  final ValueChanged<String>? onFieldSubmitted;
  final EdgeInsetsGeometry? contentPadding;
  final int maxLine;
  final Color borderColor;
  final bool isSearchIconLeft;
  final bool isShowIcon;
  final double radius;

  const TextField2({
    super.key,
    required this.hintText,
    this.controller,
    this.focusNode,
    this.nextFocus,
    this.keyboardType = TextInputType.text,
    this.fillColor = Colors.transparent,
    this.focusBorderColor,
    this.borderType = InputBorderType.outline, // default border type
    this.maxLength,
    this.textInputAction,
    this.textStyle,
    this.hintStyle,
    this.onTap,
    this.onChanged,
    this.onFieldSubmitted,
    this.contentPadding,
    this.maxLine = 1,
    this.iconColor,
    this.borderColor = MyColor.lightPrimary,
    this.isSearchIconLeft = false,
    this.isShowIcon = true,
    this.radius = 15,
  });

  @override
  State<TextField2> createState() => _TextField2State();
}

class _TextField2State extends State<TextField2> {
  bool hidePassword = true;

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        TextFormField(
          controller: widget.controller,
          focusNode: widget.focusNode,
          keyboardType: widget.keyboardType,
          maxLength: widget.maxLength,
          textInputAction: widget.textInputAction,
          maxLines: widget.maxLine,
          cursorColor: MyColor.getBodyTextColor(),
          style: widget.textStyle ?? regularLarge,
          decoration: InputDecoration(
              floatingLabelBehavior: FloatingLabelBehavior.always,
              floatingLabelStyle: regularLarge.copyWith(fontSize: 16),
              contentPadding: widget.contentPadding ??
                  const EdgeInsetsDirectional.symmetric(
                      horizontal: Dimensions.space20, vertical: 16),
              labelStyle:
                  regularLarge.copyWith(color: MyColor.getBodyTextColor()),
              hintText: widget.hintText,
              hintStyle: widget.hintStyle ??
                  regularLarge.copyWith(
                      color: MyColor.getBodyTextColor().withValues(alpha: 0.8)),
              floatingLabelAlignment: FloatingLabelAlignment.center,
              suffixIcon: widget.isSearchIconLeft || widget.isShowIcon
                  ? null
                  : UnconstrainedBox(
                      child: Material(
                        color: Colors.transparent,
                        shape: const CircleBorder(),
                        child: IconButton(
                          focusColor:
                              MyColor.getBorderColor().withValues(alpha: 0.01),
                          autofocus: false,
                          icon: CustomSvgPicture(
                              image: MyImages.search, color: widget.iconColor),
                          onPressed: () {},
                        ),
                      ),
                    ),
              prefixIcon: widget.isSearchIconLeft
                  ? UnconstrainedBox(
                      child: Material(
                        color: Colors.transparent,
                        shape: const CircleBorder(),
                        child: IconButton(
                          focusColor:
                              MyColor.getBorderColor().withValues(alpha: 0.01),
                          autofocus: false,
                          icon: CustomSvgPicture(
                              image: MyImages.search, color: widget.iconColor),
                          onPressed: () {},
                        ),
                      ),
                    )
                  : null,
              filled: true,
              fillColor: widget.fillColor,
              border: _getInputBorder(
                  color: Colors.transparent, radius: widget.radius),
              enabledBorder: _getInputBorder(
                  color: Colors.transparent, radius: widget.radius),
              focusedBorder: _getInputBorder(
                  color: Colors.transparent, radius: widget.radius)
              // focusedErrorBorder: _getInputBorder(isFocused: true, isError: true),
              ),
          onFieldSubmitted: widget.onFieldSubmitted ??
              (text) => widget.nextFocus != null
                  ? FocusScope.of(context).requestFocus(widget.nextFocus)
                  : null,
          onChanged: (text) {
            if (widget.onChanged != null) {
              widget.onChanged!(text);
            }
          },
          onTap: widget.onTap,
        ),
      ],
    );
  }

  // Helper method to get the InputBorder based on the type
  InputBorder _getInputBorder(
      {bool isFocused = false,
      bool isError = false,
      Color? color,
      double radius = 15}) {
    switch (widget.borderType) {
      case InputBorderType.outline:
        return OutlineInputBorder(
          borderRadius: BorderRadius.circular(radius),
          borderSide: BorderSide(
            color: isError
                ? Colors.red
                : isFocused
                    ? color ?? widget.borderColor
                    : widget.borderColor,
            width: 1,
          ),
        );
      case InputBorderType.none:
        return InputBorder.none;
      default:
        return OutlineInputBorder(borderRadius: BorderRadius.circular(4));
    }
  }
}

// Enum for border types
enum InputBorderType { outline, underline, none }
