import 'dart:io';
import 'package:flutter/cupertino.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/core/utils/dimensions.dart';

class PickImageSection extends StatelessWidget {
  final File? selectedFile;
  const PickImageSection({super.key, required this.selectedFile});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.all(Dimensions.space5),
      decoration: const BoxDecoration(),
      child: ClipRRect(
          borderRadius: BorderRadius.circular(Dimensions.mediumRadius),
          child: MyAssetImageWidget(
            isFile: true,
            assetPath: selectedFile?.path ?? "",
            width: 100,
            height: 100,
          )),
    );
  }
}
