import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/rounded_button.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_color.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/core/utils/style.dart';

showWarningDialog({
  required BuildContext context,
  String? desc,
  VoidCallback? onTap,
}) {
  ThemeData theme = Theme.of(context);

  showDialog(
    context: context,
    barrierDismissible: true,
    builder: (BuildContext context) {
      return AlertDialog(
        backgroundColor: theme.cardColor,
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(Dimensions.defaultRadius),
        ),
        contentPadding: const EdgeInsets.symmetric(
          vertical: Dimensions.space10,
          horizontal: Dimensions.space20,
        ),
        title: Text(
          MyStrings.areYourSure.tr,
          style: regularLarge.copyWith(
            color: MyColor.black,
            fontWeight: FontWeight.w600,
          ),
          textAlign: TextAlign.center,
        ),
        content: desc != null
            ? Text(
                desc.tr,
                textAlign: TextAlign.center,
              )
            : null,
        actionsAlignment: MainAxisAlignment.spaceEvenly,
        actionsPadding: const EdgeInsets.only(
          bottom: Dimensions.space15,
          left: Dimensions.space10,
          right: Dimensions.space10,
        ),
        actions: [
          RoundedButton(
            text: MyStrings.no.tr,
            onPress: () {
              Navigator.pop(context);
            },
            horizontalPadding: 3,
            verticalPadding: 3,
            color: MyColor.getBodyTextColor(),
          ),
          RoundedButton(
            text: MyStrings.yes.tr,
            onPress: onTap ??
                () {
                  Get.back();
                },
            horizontalPadding: 3,
            verticalPadding: 3,
            color: MyColor.getErrorColor(),
            textColor: MyColor.white,
          ),
        ],
      );
    },
  );
}
