import 'package:badges/badges.dart' as badges;
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import '../../core/route/route.dart';
import '../../core/utils/my_color.dart';
import '../../core/utils/my_images.dart';
import '../../core/utils/style.dart';
import 'image/custom_svg_picture.dart';

class CartCountWidget extends StatelessWidget {
  const CartCountWidget({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return GetBuilder<GlobalController>(
      builder: (controller) => IconButton(
        onPressed: () {
          Get.toNamed(RouteHelper.checkoutScreen)?.then((value) {
            controller.getCartCount();
          });
        },
        icon: badges.Badge(
          badgeStyle: badges.BadgeStyle(
            shape: badges.BadgeShape.circle,
            badgeColor: MyColor.getPrimaryColor(),
            padding: EdgeInsets.all(5),
            elevation: 0,
          ),
          showBadge: true,
          badgeContent: Text(controller.cartCount,
              style: regularLarge.copyWith(color: MyColor.white, fontSize: 12)),
          child: CustomSvgPicture(
            image: MyImages.cart,
            color: MyColor.getPrimaryColor(),
          ),
        ),
      ),
    );
  }
}
