import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

class BottomNavFloatingButton extends StatelessWidget {
  const BottomNavFloatingButton({super.key});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GestureDetector(
      onTap: () {
        Get.toNamed(RouteHelper.qrcodeScannerScreen);
      },
      child: Container(
        height: Dimensions.space80.h,
        width: Dimensions.space80.w,
        padding: EdgeInsetsDirectional.all(Dimensions.space20),
        decoration: BoxDecoration(
          color: theme.cardColor,
          shape: BoxShape.circle,
          border: Border.all(color: theme.primaryColor),
          boxShadow: [
            BoxShadow(
              color: theme.primaryColor.withValues(alpha: .4.h),
              blurRadius: Dimensions.space15.h,
            ),
          ],
        ),
        child: MyAssetImageWidget(
          assetPath: MyIcons.scan,
          isSvg: true,
          height: Dimensions.space40.h,
          width: Dimensions.space40.w,
        ),
      ),
    );
  }
}
