import 'package:animated_bottom_navigation_bar/animated_bottom_navigation_bar.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/bottom-nav-bar/bottom_nav_floating_button.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/will_pop_widget.dart';
import 'package:ovosale/app/screens/bottom_nav_section/home/home_screen.dart';
import 'package:ovosale/app/screens/bottom_nav_section/more/more_screen.dart';
import 'package:ovosale/app/screens/bottom_nav_section/products/manage_products_screen.dart';
import 'package:ovosale/app/screens/report/report_screen.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/repo/cart/globalRepo.dart';

class AnimatedBottomNavBar extends StatefulWidget {
  const AnimatedBottomNavBar({super.key});

  @override
  AnimatedBottomNavBarState createState() => AnimatedBottomNavBarState();
}

class AnimatedBottomNavBarState extends State<AnimatedBottomNavBar> {
  final GlobalKey<ScaffoldState> _scaffoldKey = GlobalKey<ScaffoldState>();
  int _bottomNavIndex = 0;

  final iconList = <String>[
    MyIcons.homes,
    MyIcons.products,
    MyIcons.report,
    MyIcons.more,
  ];
  final titleList = <String>[
    MyStrings.home.tr,
    MyStrings.products.tr,
    MyStrings.report.tr,
    MyStrings.more.tr,
  ];

  late List<Widget> _screens;

  @override
  void initState() {
    super.initState();

    Get.put(GlobalRepo());
    Get.put(GlobalController(globalCartCountRepo: Get.find()));

    _screens = [
      HomeScreen(bottomNavScaffoldKey: _scaffoldKey),
      ManageProductsScreen(),
      // HomeScreen(bottomNavScaffoldKey: _scaffoldKey),
      ReportScreen(),
      MoreScreen(),
    ];

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      // controller.loadData();
    });
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return WillPopWidget(
      child: Scaffold(
        extendBody: true,
        key: _scaffoldKey,
        body: _screens[_bottomNavIndex],
        floatingActionButton: Visibility(
            visible: MediaQuery.of(context).viewInsets.bottom == 0.0,
            child: BottomNavFloatingButton()),
        floatingActionButtonLocation: FloatingActionButtonLocation.centerDocked,
        bottomNavigationBar: AnimatedBottomNavigationBar.builder(
            height: Dimensions.space80,
            itemCount: iconList.length,
            tabBuilder: (int index, bool isActive) {
              final iconPath = iconList[index];
              return Padding(
                padding: const EdgeInsetsDirectional.symmetric(
                    horizontal: Dimensions.space5,
                    vertical: Dimensions.space12),
                child: Column(
                  children: [
                    MyAssetImageWidget(
                      assetPath: iconPath,
                      height: Dimensions.space24.h,
                      width: Dimensions.space24.w,
                      isSvg: true,
                      color: isActive
                          ? theme.bottomNavigationBarTheme.selectedItemColor!
                          : theme.bottomNavigationBarTheme.unselectedItemColor!,
                    ),
                    Text(
                      titleList[index].toString().tr,
                      style: theme.textTheme.labelSmall?.copyWith(
                          color: isActive
                              ? theme
                                  .bottomNavigationBarTheme.selectedItemColor!
                              : theme.bottomNavigationBarTheme
                                  .unselectedItemColor!),
                    )
                  ],
                ),
              );
            },
            backgroundColor: theme.cardColor,
            activeIndex: _bottomNavIndex,
            gapLocation: GapLocation.center,
            splashColor: theme.primaryColorLight,
            notchSmoothness: NotchSmoothness.defaultEdge,
            onTap: (index) {
              setState(() {
                _bottomNavIndex = index;
              });
            }),
      ),
    );
  }
}
